/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.nativeimage.debugger.displayer;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.java.nativeimage.debugger.displayer.Bundle;
import org.netbeans.modules.java.nativeimage.debugger.displayer.DynamicHub;
import org.netbeans.modules.java.nativeimage.debugger.displayer.Utils;
import org.netbeans.modules.nativeimage.api.debug.EvaluateException;
import org.netbeans.modules.nativeimage.api.debug.NIDebugger;
import org.netbeans.modules.nativeimage.api.debug.NIFrame;
import org.netbeans.modules.nativeimage.api.debug.NIVariable;
import org.netbeans.modules.nativeimage.spi.debug.filters.VariableDisplayer;

public final class JavaVariablesDisplayer
implements VariableDisplayer {
    private static final String HUB = "__hub__";
    private static final String ARRAY = "__array__";
    private static final String ARRAY_LENGTH = "__length__";
    private static final String ARRAY_LENGTH_CE = "len";
    private static final String ARRAY_DATA_CE = "data";
    private static final String OBJ_HEADER_CE = "_objhdr";
    private static final String COMPRESSED_REF_REFIX = "_z_.";
    static final String PUBLIC = "public";
    static final String PRIVATE = "private";
    private static final String PROTECTED = "protected";
    private static final String STRING_VALUE = "value";
    private static final String STRING_CODER = "coder";
    private static final String HASH = "hash";
    private static final String NAME = "name";
    private static final String UNSET = "<optimized out>";
    private static final String[] STRING_TYPES = new String[]{String.class.getName(), StringBuilder.class.getName(), StringBuffer.class.getName()};
    private static final String PREFIX_VAR_PATH = "{ ";
    private static final Logger LOG = Logger.getLogger(JavaVariablesDisplayer.class.getName());
    private NIDebugger debugger;
    private final Map<NIVariable, String> variablePaths = Collections.synchronizedMap(new WeakHashMap());

    public void setDebugger(NIDebugger debugger) {
        this.debugger = debugger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NIVariable[] displayed(NIVariable[] variables) {
        ArrayList<NIVariable> displayedVars = new ArrayList<NIVariable>(variables.length);
        for (NIVariable var : variables) {
            AbstractVar displayedVar;
            int nch;
            int i;
            String value = var.getValue();
            if (UNSET.equals(value)) continue;
            if (var instanceof AbstractVar) {
                displayedVars.add(var);
                continue;
            }
            String name = var.getName();
            String path = null;
            if (name.startsWith(PREFIX_VAR_PATH) && (i = name.indexOf(32, PREFIX_VAR_PATH.length())) > 0) {
                path = name.substring(i + 1);
                name = name.substring(PREFIX_VAR_PATH.length(), i);
            }
            if (path != null) {
                this.variablePaths.put(var, path);
            }
            if ((nch = var.getNumChildren()) == 0) {
                displayedVar = new Var(var, name, path);
            } else {
                NIVariable[] subChildren;
                NIVariable[] children = var.getChildren();
                NIVariable[] nIVariableArray = subChildren = children.length > 0 ? children[0].getChildren() : new NIVariable[]{};
                if (subChildren.length == 3 && ARRAY_LENGTH.equals(subChildren[1].getName()) && ARRAY.equals(subChildren[2].getName())) {
                    displayedVar = new ArrayVar(var, name, path, subChildren[1], subChildren[2]);
                } else {
                    String type = JavaVariablesDisplayer.getSimpleType(var.getType());
                    boolean isString = STRING_TYPES[0].equals(type);
                    boolean likeString = isString;
                    if (!likeString) {
                        for (String strType : STRING_TYPES) {
                            if (!strType.equals(type)) continue;
                            likeString = true;
                            break;
                        }
                    }
                    if (likeString) {
                        displayedVar = new StringVar(var, name, path, type, isString ? null : subChildren);
                    } else if (children.length == 1 && PUBLIC.equals(children[0].getName())) {
                        displayedVar = new ObjectVarEE(var, name, path, subChildren);
                    } else {
                        DynamicHub hub = DynamicHub.find(var);
                        if (hub != null) {
                            AbstractVar objectVar = null;
                            DynamicHub.HubType hubType = hub.getType();
                            if (hubType != null) {
                                switch (hubType) {
                                    case OBJECT: {
                                        objectVar = new ObjectVarCE(var, name, path, children, hub);
                                        break;
                                    }
                                    case ARRAY: {
                                        NIVariable lengthVar = Utils.findChild(children, PUBLIC, ARRAY_LENGTH_CE);
                                        NIVariable dataVar = Utils.findChild(children, PUBLIC, ARRAY_DATA_CE);
                                        if (lengthVar == null && dataVar == null) break;
                                        objectVar = new ArrayVarCE(var, name, lengthVar, dataVar, hub);
                                    }
                                }
                            }
                            displayedVar = objectVar != null ? objectVar : new Var(var, name, path);
                        } else {
                            displayedVar = new Var(var, name, path);
                        }
                    }
                }
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(var.getName() + " => " + displayedVar + (String)(displayedVar != null ? "[" + displayedVar.getName() + "]" : ""));
            }
            if (displayedVar != var) {
                Map<NIVariable, String> map = this.variablePaths;
                synchronized (map) {
                    this.variablePaths.put(displayedVar, this.variablePaths.get(var));
                }
            }
            displayedVars.add(displayedVar);
        }
        return displayedVars.toArray(new NIVariable[0]);
    }

    private static String displayType(String type) {
        if (type.startsWith(COMPRESSED_REF_REFIX)) {
            type = type.substring(COMPRESSED_REF_REFIX.length());
        }
        if (type.endsWith("*")) {
            type = type.substring(0, type.length() - 1).trim();
        }
        return type;
    }

    private static String getSimpleType(String type) {
        type = JavaVariablesDisplayer.displayType(type);
        for (int i = 0; i < type.length(); ++i) {
            char c = type.charAt(i);
            if (c == '.' || c == '[' || c == ']' || Character.isJavaIdentifierPart(c)) continue;
            return type.substring(0, i);
        }
        return type;
    }

    private static boolean isOfType(String varType, String type) {
        return (varType = JavaVariablesDisplayer.displayType(varType)).equals(type) || varType.startsWith(type) && !Character.isJavaIdentifierPart(varType.charAt(type.length()));
    }

    private static int getTypeSize(String type) {
        switch (type = JavaVariablesDisplayer.getSimpleType(type)) {
            case "boolean": 
            case "byte": {
                return 1;
            }
            case "char": 
            case "short": {
                return 2;
            }
            case "int": 
            case "float": {
                return 4;
            }
            case "long": 
            case "double": {
                return 8;
            }
        }
        return 8;
    }

    private static NIVariable[] restrictChildren(NIVariable[] children, int from, int to) {
        if (from > 0 || to < children.length) {
            children = from < (to = Math.min(to, children.length)) ? Arrays.copyOfRange(children, from, to) : new NIVariable[]{};
        }
        return children;
    }

    private static String getHash(NIVariable[] children) {
        for (NIVariable child : children) {
            if (!HASH.equals(child.getName())) continue;
            String hash = child.getValue();
            try {
                hash = Integer.toHexString(Integer.parseInt(hash));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            return hash;
        }
        return null;
    }

    private static String getArrayExpression(NIVariable variable) {
        StringBuilder arrayExpression = new StringBuilder(variable.getName());
        while ((variable = variable.getParent()) != null) {
            if (PUBLIC.equals(variable.getName())) continue;
            arrayExpression.insert(0, '.');
            arrayExpression.insert(0, variable.getName());
        }
        return arrayExpression.toString();
    }

    private static String getNameOrIndex(String name) {
        int i;
        if (name.endsWith("]") && (i = name.lastIndexOf("__array__[")) > 0) {
            String index = name.substring(i + ARRAY.length() + 1, name.length() - 1);
            return index;
        }
        return name;
    }

    private String readArrayEE(NIVariable lengthVariable, int itemSize) {
        int length = Integer.parseInt(lengthVariable.getValue());
        String expressionPath = this.getExpressionPath(lengthVariable);
        if (expressionPath != null && !expressionPath.isEmpty()) {
            String addressExpr = "&" + expressionPath;
            return this.debugger.readMemory(addressExpr, 4L, length * itemSize);
        }
        return null;
    }

    private String readArrayCE(String arrayPath, int length, int itemSize) {
        if (arrayPath != null && !arrayPath.isEmpty()) {
            String addressExpr = "&" + arrayPath;
            return this.debugger.readMemory(addressExpr, 0L, length * itemSize);
        }
        return null;
    }

    private static NIVariable[] getObjectChildren(NIVariable[] children, int from, int to) {
        for (int i = 0; i < children.length; ++i) {
            if (!HUB.equals(children[i].getName())) continue;
            NIVariable[] ch1 = Arrays.copyOf(children, i);
            NIVariable[] ch2 = Arrays.copyOfRange(children, i + 1, children.length);
            if (ch1.length == 0) {
                return ch2;
            }
            if (ch2.length == 0) {
                return ch1;
            }
            NIVariable[] ch = new NIVariable[ch1.length + ch2.length];
            System.arraycopy(ch1, 0, ch, 0, ch1.length);
            System.arraycopy(ch2, 0, ch, ch1.length, ch2.length);
            return ch;
        }
        return JavaVariablesDisplayer.restrictChildren(children, from, to);
    }

    private static boolean isPrimitiveArray(String type) {
        String name;
        int i = type.indexOf(32);
        if (i < 0) {
            return false;
        }
        switch (name = type.substring(0, i)) {
            case "boolean": 
            case "byte": 
            case "char": 
            case "short": 
            case "int": 
            case "long": 
            case "float": 
            case "double": {
                return true;
            }
        }
        return false;
    }

    private String getExpressionPath(NIVariable var) {
        String path = var.getExpressionPath();
        if (!path.isEmpty()) {
            path = Utils.quoteJavaTypes(path);
            return path;
        }
        return this.createExpressionPath(var);
    }

    private String createExpressionPath(NIVariable var) {
        String path = this.variablePaths.get(var);
        if (path != null) {
            return path;
        }
        path = var.getName();
        NIVariable parent = var.getParent();
        if (parent == null) {
            return path;
        }
        String parentPath = this.createExpressionPath(parent);
        if (PUBLIC.equals(path) || PRIVATE.equals(path) || path.contains(" ")) {
            return parentPath;
        }
        return parentPath + "." + path;
    }

    private NIVariable[] computeMembers(NIVariable[] children) {
        Map<String, NIVariable> varsByName = Utils.getVarsByName(children);
        NIVariable[] vars = new NIVariable[]{varsByName.get(PRIVATE), varsByName.get(PROTECTED), varsByName.get(PUBLIC)};
        ArrayList<NIVariable> collected = new ArrayList<NIVariable>();
        for (NIVariable folder : vars) {
            if (folder == null) continue;
            for (NIVariable v : folder.getChildren()) {
                collected.add(v);
            }
        }
        NIVariable inherited = this.createInherited(children);
        if (collected.isEmpty()) {
            if (inherited == null) {
                return new NIVariable[0];
            }
            return inherited.getChildren();
        }
        if (inherited != null) {
            collected.add(inherited);
        }
        return collected.toArray(new NIVariable[0]);
    }

    private NIVariable createInherited(NIVariable[] children) {
        if (children.length == 0) {
            return null;
        }
        NIVariable superClass = children[0];
        if (superClass.getName().equals(OBJ_HEADER_CE)) {
            return null;
        }
        NIVariable[] superChildren = superClass.getChildren();
        if (superChildren.length == 1) {
            return this.createInherited(superChildren);
        }
        return new Inherited(superClass);
    }

    private abstract class AbstractVar
    implements NIVariable {
        protected final NIVariable var;
        protected final String varName;
        protected final String varPath;

        AbstractVar(NIVariable var, String varName, String varPath) {
            if (var == null) {
                throw new NullPointerException("Null variable.");
            }
            this.var = var;
            this.varName = varName;
            this.varPath = varPath;
        }

        public final String getName() {
            if (this.varName != null) {
                return this.varName;
            }
            return JavaVariablesDisplayer.getNameOrIndex(this.var.getName());
        }

        public final String getExpressionPath() {
            if (this.varPath != null) {
                return this.varPath;
            }
            String path = this.var.getExpressionPath();
            if (!path.isEmpty()) {
                return path;
            }
            path = JavaVariablesDisplayer.this.variablePaths.get(this.var);
            return path != null ? path : this.getName();
        }
    }

    private class Var
    extends AbstractVar {
        Var(NIVariable var, String name, String path) {
            super(var, name, path);
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }

        public String getType() {
            return this.var.getType();
        }

        public String getValue() {
            return this.var.getValue();
        }

        public int getNumChildren() {
            return this.var.getNumChildren();
        }

        public NIVariable[] getChildren(int from, int to) {
            return this.var.getChildren(from, to);
        }

        public NIVariable[] getChildren() {
            return this.var.getChildren();
        }
    }

    private class ArrayVar
    extends AbstractVar {
        private final NIVariable lengthVariable;
        private final int length;
        private final NIVariable array;

        ArrayVar(NIVariable var, String name, String path, NIVariable lengthVariable, NIVariable array) {
            int arrayLength;
            super(var, name, path);
            this.lengthVariable = lengthVariable;
            try {
                arrayLength = Integer.parseInt(lengthVariable.getValue());
            }
            catch (NumberFormatException ex) {
                arrayLength = 0;
            }
            this.length = arrayLength;
            this.array = array;
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }

        public String getType() {
            return JavaVariablesDisplayer.displayType(this.var.getType());
        }

        public String getValue() {
            Object value = this.var.getValue();
            if (((String)value).startsWith("@")) {
                value = this.getType() + (String)value;
            }
            return (String)value + "(length=" + this.length + ")";
        }

        public int getNumChildren() {
            return this.length;
        }

        public NIVariable[] getChildren(int from, int to) {
            String expressionPath;
            if (from >= 0) {
                to = Math.min(to, this.length);
            } else {
                from = 0;
                to = this.length;
            }
            if (from >= to) {
                return new NIVariable[0];
            }
            String arrayAddress = null;
            if (JavaVariablesDisplayer.isPrimitiveArray(this.array.getType()) && (expressionPath = JavaVariablesDisplayer.this.getExpressionPath(this.lengthVariable)) != null && !expressionPath.isEmpty()) {
                NIVariable addressVariable;
                String addressExpr = "&" + expressionPath;
                try {
                    addressVariable = JavaVariablesDisplayer.this.debugger.evaluate(addressExpr, null, this.lengthVariable.getFrame());
                }
                catch (EvaluateException ex) {
                    addressVariable = null;
                }
                if (addressVariable != null) {
                    String address = addressVariable.getValue();
                    if ((address = address.toLowerCase()).startsWith("0x")) {
                        arrayAddress = address;
                    }
                }
            }
            NIVariable[] elements = new NIVariable[to - from];
            try {
                if (arrayAddress != null) {
                    int offset = JavaVariablesDisplayer.getTypeSize(this.getType()) == 8 ? 8 : 4;
                    String itemExpression = "*(((" + JavaVariablesDisplayer.getSimpleType(this.getType()) + "*)(" + arrayAddress + "+" + offset + "))+";
                    int size = JavaVariablesDisplayer.getTypeSize(this.getType());
                    for (int i = from; i < to; ++i) {
                        NIVariable element;
                        String expr = itemExpression + i + ")";
                        elements[i - from] = element = JavaVariablesDisplayer.this.debugger.evaluate(expr, Integer.toString(i), this.var.getFrame());
                    }
                } else {
                    String arrayExpression = JavaVariablesDisplayer.this.getExpressionPath(this.array);
                    for (int i = from; i < to; ++i) {
                        String expr = arrayExpression + "[" + i + "]";
                        String namePath = JavaVariablesDisplayer.PREFIX_VAR_PATH + Integer.toString(i) + " " + expr;
                        NIVariable element = JavaVariablesDisplayer.this.debugger.evaluate(expr, namePath, this.var.getFrame());
                        JavaVariablesDisplayer.this.variablePaths.put(element, expr);
                        elements[i - from] = element;
                    }
                }
            }
            catch (EvaluateException ex) {
                return new NIVariable[0];
            }
            return elements;
        }
    }

    private class StringVar
    extends AbstractVar {
        private final String type;
        private final NIVariable[] children;

        StringVar(NIVariable var, String name, String path, String type, NIVariable[] children) {
            super(var, name, path);
            this.type = type;
            this.children = children;
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            NIVariable pub = Utils.getVarsByName(this.var.getChildren()).get(JavaVariablesDisplayer.PUBLIC);
            if (pub != null && Utils.getVarsByName(pub.getChildren()).get(JavaVariablesDisplayer.HUB) != null) {
                return this.getValueEE(pub);
            }
            return this.getValueCE();
        }

        private String getValueEE(NIVariable pub) {
            Map<String, NIVariable> varChildren = Utils.getVarsByName(pub.getChildren());
            Map<String, NIVariable> arrayInfo = Utils.getVarsByName(varChildren.get(JavaVariablesDisplayer.STRING_VALUE).getChildren());
            arrayInfo = Utils.getVarsByName(arrayInfo.get(JavaVariablesDisplayer.PUBLIC).getChildren());
            NIVariable arrayVariable = arrayInfo.get(JavaVariablesDisplayer.ARRAY);
            NIVariable lengthVariable = arrayInfo.get(JavaVariablesDisplayer.ARRAY_LENGTH);
            String lengthStr = lengthVariable.getValue();
            if (lengthStr.isEmpty()) {
                return "?";
            }
            int length = Integer.parseInt(lengthStr);
            if (length <= 0) {
                return "?";
            }
            NIVariable coderVar = varChildren.get(JavaVariablesDisplayer.STRING_CODER);
            int coder = this.parseCoder(coderVar);
            String hexArray = JavaVariablesDisplayer.this.readArrayEE(lengthVariable, 2);
            if (hexArray != null) {
                return this.parseStringFromHEX(hexArray, length, coder);
            }
            String arrayExpression = JavaVariablesDisplayer.this.getExpressionPath(arrayVariable);
            return this.parseStringFromArray(arrayExpression, length, coder);
        }

        private String getValueCE() {
            Map<String, NIVariable> varPrivChildren = Utils.getVarsByName(this.var.getChildren());
            NIVariable priv = varPrivChildren.get(JavaVariablesDisplayer.PRIVATE);
            if (priv == null) {
                NIVariable strVar = varPrivChildren.get(String.class.getName());
                if (strVar != null) {
                    priv = Utils.getVarsByName(strVar.getChildren()).get(JavaVariablesDisplayer.PRIVATE);
                }
                if (priv == null) {
                    return "?";
                }
            }
            Map<String, NIVariable> varChildren = Utils.getVarsByName(priv.getChildren());
            NIVariable value = varChildren.get(JavaVariablesDisplayer.STRING_VALUE);
            NIVariable coderVar = varChildren.get(JavaVariablesDisplayer.STRING_CODER);
            int coder = this.parseCoder(coderVar);
            if (value == null || value.getNumChildren() == 0) {
                return "?";
            }
            NIVariable valueTypeChild = value.getChildren()[0];
            NIVariable valuePublic = Utils.getVarsByName(valueTypeChild.getChildren()).get(JavaVariablesDisplayer.PUBLIC);
            if (valuePublic == null) {
                return "";
            }
            Map<String, NIVariable> arrayChildren = Utils.getVarsByName(valuePublic.getChildren());
            NIVariable lengthVar = arrayChildren.get(JavaVariablesDisplayer.ARRAY_LENGTH_CE);
            NIVariable dataVar = arrayChildren.get(JavaVariablesDisplayer.ARRAY_DATA_CE);
            if (lengthVar == null || dataVar == null) {
                return "?";
            }
            String lengthStr = lengthVar.getValue();
            if (lengthStr.isEmpty()) {
                return "";
            }
            int length = Integer.parseInt(lengthStr);
            Object arrayPath = JavaVariablesDisplayer.this.getExpressionPath(value);
            String hexArray = null;
            if (arrayPath != null && !((String)arrayPath).isEmpty()) {
                arrayPath = (String)arrayPath + ".data";
                hexArray = JavaVariablesDisplayer.this.readArrayCE((String)arrayPath, length, 2);
            }
            if (hexArray != null) {
                return this.parseStringFromHEX(hexArray, length, coder);
            }
            return this.parseStringFromArray((String)arrayPath, length, coder);
        }

        private int parseCoder(NIVariable coderVar) {
            int coder = -1;
            if (coderVar != null) {
                String coderStr = coderVar.getValue();
                int space = coderStr.indexOf(32);
                if (space > 0) {
                    coderStr = coderStr.substring(0, space);
                }
                try {
                    coder = Integer.parseInt(coderStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return coder;
        }

        private char parseCharacter(String charValue) {
            byte b0;
            byte b1;
            if (charValue.startsWith("'") && charValue.endsWith("'")) {
                charValue = charValue.substring(1, charValue.length() - 1);
            }
            if (charValue.startsWith("\\\\x")) {
                b1 = this.parseByte(charValue, 3);
                b0 = this.parseByte(charValue, 5);
            } else {
                int[] pos = new int[]{0};
                try {
                    b1 = this.getByteFromChar(charValue, pos);
                    charValue = charValue.substring(pos[0]);
                    b0 = this.getByteFromChar(charValue, pos);
                }
                catch (NumberFormatException nfex) {
                    try {
                        return (char)Short.parseShort(charValue.substring(2), 8);
                    }
                    catch (NumberFormatException ex) {
                        return charValue.charAt(0);
                    }
                }
            }
            CharsetDecoder cd = Charset.forName("utf-16").newDecoder();
            byte[] bytes = new byte[]{b1, b0};
            ByteBuffer buffer = ByteBuffer.allocate(2);
            buffer.rewind();
            buffer.put(b0);
            buffer.put(b1);
            buffer.rewind();
            try {
                char c = cd.decode(buffer).get();
                return c;
            }
            catch (CharacterCodingException ex) {
                return charValue.charAt(0);
            }
        }

        private byte getByteFromChar(String charValue, int[] pos) {
            if (charValue.startsWith("\\\\")) {
                pos[0] = pos[0] + 2;
                char c = charValue.charAt(2);
                if (Character.isDigit(c)) {
                    pos[0] = pos[0] + 3;
                    return Byte.parseByte(charValue.substring(2, 5), 8);
                }
                pos[0] = pos[0] + 1;
                switch (c) {
                    case 'a': {
                        return 7;
                    }
                    case 'b': {
                        return 8;
                    }
                    case 't': {
                        return 9;
                    }
                    case 'n': {
                        return 10;
                    }
                    case 'v': {
                        return 11;
                    }
                    case 'f': {
                        return 12;
                    }
                    case 'r': {
                        return 13;
                    }
                    case '\\': {
                        pos[0] = pos[0] + 1;
                        return (byte)c;
                    }
                }
                return (byte)c;
            }
            pos[0] = pos[0] + 1;
            return (byte)charValue.charAt(0);
        }

        private String parseStringFromHEX(String hexArray, int length, int coder) {
            switch (coder) {
                case 0: {
                    return this.parseLatin1(hexArray, length);
                }
                case 1: {
                    return this.parseUTF16(hexArray, length / 2);
                }
            }
            return this.parseUTF16(hexArray, length);
        }

        private String parseUTF16(String hexArray, int length) {
            CharsetDecoder cd = Charset.forName("utf-16").newDecoder();
            ByteBuffer buffer = ByteBuffer.allocate(2);
            char[] characters = new char[length];
            int ih = 0;
            for (int i = 0; i < length; ++i) {
                byte b1 = this.parseByte(hexArray, ih);
                byte b0 = this.parseByte(hexArray, ih += 2);
                ih += 2;
                buffer.rewind();
                buffer.put(b0);
                buffer.put(b1);
                buffer.rewind();
                try {
                    char c;
                    characters[i] = c = cd.decode(buffer).get();
                    continue;
                }
                catch (CharacterCodingException characterCodingException) {
                    // empty catch block
                }
            }
            return new String(characters);
        }

        private String parseLatin1(String hexArray, int length) {
            CharsetDecoder cd = Charset.forName("latin1").newDecoder();
            ByteBuffer buffer = ByteBuffer.allocate(1);
            char[] characters = new char[length];
            int ih = 0;
            for (int i = 0; i < length; ++i) {
                byte b = this.parseByte(hexArray, ih);
                ih += 2;
                buffer.rewind();
                buffer.put(b);
                buffer.rewind();
                try {
                    char c;
                    characters[i] = c = cd.decode(buffer).get();
                    continue;
                }
                catch (CharacterCodingException characterCodingException) {
                    // empty catch block
                }
            }
            return new String(characters);
        }

        private byte parseByte(String hexArray, int offset) {
            String hex = new String(new char[]{hexArray.charAt(offset), hexArray.charAt(offset + 1)});
            return (byte)(Integer.parseInt(hex, 16) & 0xFF);
        }

        private String parseStringFromArray(String arrayExpression, int length, int coder) {
            NIFrame frame = this.var.getFrame();
            try {
                NIVariable charVar = JavaVariablesDisplayer.this.debugger.evaluate(arrayExpression + "[0]", null, frame);
                if ("byte".equals(charVar.getType())) {
                    switch (coder) {
                        case 0: {
                            return this.parseLatin1(arrayExpression, frame, length);
                        }
                        case 1: {
                            return this.parseUTF16(arrayExpression, frame, length / 2);
                        }
                    }
                    return this.parseUTF16(arrayExpression, frame, length);
                }
                char[] characters = new char[length];
                int i = 0;
                while (true) {
                    String charStr = charVar.getValue();
                    characters[i] = this.parseCharacter(charStr);
                    if (++i >= length) break;
                    charVar = JavaVariablesDisplayer.this.debugger.evaluate(arrayExpression + "[" + i + "]", null, frame);
                }
                return new String(characters);
            }
            catch (EvaluateException ex) {
                return ex.getLocalizedMessage();
            }
        }

        private String parseUTF16(String arrayExpression, NIFrame frame, int length) throws EvaluateException {
            CharsetDecoder cd = Charset.forName("utf-16").newDecoder();
            ByteBuffer buffer = ByteBuffer.allocate(2);
            char[] characters = new char[length];
            for (int i = 0; i < length; ++i) {
                NIVariable byteVar = JavaVariablesDisplayer.this.debugger.evaluate(arrayExpression + "[" + 2 * i + "]", null, frame);
                byte b1 = Byte.parseByte(byteVar.getValue());
                byteVar = JavaVariablesDisplayer.this.debugger.evaluate(arrayExpression + "[" + (2 * i + 1) + "]", null, frame);
                byte b0 = Byte.parseByte(byteVar.getValue());
                buffer.rewind();
                buffer.put(b0);
                buffer.put(b1);
                buffer.rewind();
                try {
                    char c;
                    characters[i] = c = cd.decode(buffer).get();
                    continue;
                }
                catch (CharacterCodingException characterCodingException) {
                    // empty catch block
                }
            }
            return new String(characters);
        }

        private String parseLatin1(String arrayExpression, NIFrame frame, int length) throws EvaluateException {
            CharsetDecoder cd = Charset.forName("latin1").newDecoder();
            ByteBuffer buffer = ByteBuffer.allocate(1);
            char[] characters = new char[length];
            for (int i = 0; i < length; ++i) {
                NIVariable byteVar = JavaVariablesDisplayer.this.debugger.evaluate(arrayExpression + "[" + i + "]", null, frame);
                byte b = Byte.parseByte(byteVar.getValue());
                buffer.rewind();
                buffer.put(b);
                buffer.rewind();
                try {
                    char c;
                    characters[i] = c = cd.decode(buffer).get();
                    continue;
                }
                catch (CharacterCodingException characterCodingException) {
                    // empty catch block
                }
            }
            return new String(characters);
        }

        public int getNumChildren() {
            return this.children != null ? this.children.length : 0;
        }

        public NIVariable[] getChildren(int from, int to) {
            return this.children != null ? JavaVariablesDisplayer.getObjectChildren(this.children, from, to) : new NIVariable[]{};
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }
    }

    private class ObjectVarEE
    extends AbstractVar {
        protected final NIVariable[] children;

        ObjectVarEE(NIVariable var, String name, String path, NIVariable[] children) {
            super(var, name, path);
            if (children == null) {
                throw new NullPointerException("Null children.");
            }
            this.children = children;
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }

        public String getType() {
            return JavaVariablesDisplayer.displayType(this.findRuntimeType());
        }

        public String getValue() {
            Object value = this.var.getValue();
            if (((String)value).startsWith("@") || ((String)value).startsWith("0x")) {
                String hash = JavaVariablesDisplayer.getHash(this.children);
                if (hash == null) {
                    hash = ((String)value).startsWith("@") ? ((String)value).substring(1) : ((String)value).substring(2);
                }
                value = this.getType() + "@" + hash;
            }
            return value;
        }

        public int getNumChildren() {
            return this.children.length;
        }

        public NIVariable[] getChildren(int from, int to) {
            return JavaVariablesDisplayer.getObjectChildren(this.children, from, to);
        }

        protected String findRuntimeType() {
            String name;
            NIVariable nameVar;
            if (this.children.length > 0 && (nameVar = Utils.findChild(this.children, JavaVariablesDisplayer.HUB, JavaVariablesDisplayer.PUBLIC, JavaVariablesDisplayer.NAME)) != null && !(name = new StringVar(nameVar, this.varName, this.varPath, null, null).getValue()).isEmpty()) {
                return name;
            }
            return this.var.getType();
        }
    }

    private class ObjectVarCE
    extends ObjectVarEE {
        private final DynamicHub hub;
        private NIVariable[] members;

        ObjectVarCE(NIVariable var, String name, String path, NIVariable[] children, DynamicHub hub) {
            super(var, name, path, children);
            this.hub = hub;
        }

        @Override
        public int getNumChildren() {
            return this.getMemberChildren().length;
        }

        @Override
        public NIVariable[] getChildren(int from, int to) {
            return this.getMemberChildren();
        }

        @Override
        protected String findRuntimeType() {
            String name;
            NIVariable nameVar = this.hub.findClassNameVar();
            if (nameVar != null && !(name = new StringVar(nameVar, this.varName, this.varPath, null, null).getValue()).isEmpty()) {
                return name;
            }
            return this.var.getType();
        }

        private synchronized NIVariable[] getMemberChildren() {
            if (this.members == null) {
                this.members = JavaVariablesDisplayer.this.computeMembers(this.children);
            }
            return this.members;
        }
    }

    private class ArrayVarCE
    extends AbstractVar {
        private final NIVariable lengthVariable;
        private final int length;
        private final NIVariable array;

        ArrayVarCE(NIVariable var, String name, NIVariable lengthVariable, NIVariable dataVar, DynamicHub hub) {
            int arrayLength;
            super(var, name, "");
            this.lengthVariable = lengthVariable;
            try {
                arrayLength = Integer.parseInt(lengthVariable.getValue());
            }
            catch (NumberFormatException ex) {
                arrayLength = 0;
            }
            this.length = arrayLength;
            this.array = dataVar;
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }

        public String getType() {
            return JavaVariablesDisplayer.displayType(this.var.getType());
        }

        public String getValue() {
            Object value = this.var.getValue();
            if (((String)value).startsWith("@")) {
                value = this.getType() + (String)value;
            }
            return (String)value + "(length=" + this.length + ")";
        }

        public int getNumChildren() {
            return this.length;
        }

        public NIVariable[] getChildren(int from, int to) {
            String expressionPath;
            if (from >= 0) {
                to = Math.min(to, this.length);
            } else {
                from = 0;
                to = this.length;
            }
            if (from >= to) {
                return new NIVariable[0];
            }
            String arrayAddress = null;
            if (JavaVariablesDisplayer.isPrimitiveArray(this.array.getType()) && (expressionPath = JavaVariablesDisplayer.this.getExpressionPath(this.lengthVariable)) != null && !expressionPath.isEmpty()) {
                NIVariable addressVariable;
                String addressExpr = "&" + expressionPath;
                try {
                    addressVariable = JavaVariablesDisplayer.this.debugger.evaluate(addressExpr, null, this.lengthVariable.getFrame());
                }
                catch (EvaluateException ex) {
                    addressVariable = null;
                }
                if (addressVariable != null) {
                    String address = addressVariable.getValue();
                    if ((address = address.toLowerCase()).startsWith("0x")) {
                        arrayAddress = address;
                    }
                }
            }
            NIVariable[] elements = new NIVariable[to - from];
            try {
                if (arrayAddress != null) {
                    int offset = JavaVariablesDisplayer.getTypeSize(this.getType()) == 8 ? 8 : 4;
                    String itemExpression = "*(((" + JavaVariablesDisplayer.getSimpleType(this.getType()) + "*)(" + arrayAddress + "+" + offset + "))+";
                    int size = JavaVariablesDisplayer.getTypeSize(this.getType());
                    for (int i = from; i < to; ++i) {
                        NIVariable element;
                        String expr = itemExpression + i + ")";
                        elements[i - from] = element = JavaVariablesDisplayer.this.debugger.evaluate(expr, Integer.toString(i), this.var.getFrame());
                    }
                } else {
                    String arrayExpression = JavaVariablesDisplayer.this.getExpressionPath(this.array);
                    for (int i = from; i < to; ++i) {
                        String expr = arrayExpression + "[" + i + "]";
                        String namePath = JavaVariablesDisplayer.PREFIX_VAR_PATH + Integer.toString(i) + " " + expr;
                        NIVariable element = JavaVariablesDisplayer.this.debugger.evaluate(expr, namePath, this.var.getFrame());
                        JavaVariablesDisplayer.this.variablePaths.put(element, expr);
                        elements[i - from] = element;
                    }
                }
            }
            catch (EvaluateException ex) {
                return new NIVariable[0];
            }
            return elements;
        }
    }

    private class Inherited
    extends AbstractVar {
        private NIVariable[] members;

        Inherited(NIVariable typeVar) {
            super(typeVar, Bundle.LBL_Inherited(typeVar.getName()), "");
        }

        public String getType() {
            return "";
        }

        public String getValue() {
            return "";
        }

        public NIVariable getParent() {
            return this.var.getParent();
        }

        public int getNumChildren() {
            return this.getMemberChildren().length;
        }

        public NIVariable[] getChildren(int from, int to) {
            return this.getMemberChildren();
        }

        private synchronized NIVariable[] getMemberChildren() {
            if (this.members == null) {
                this.members = JavaVariablesDisplayer.this.computeMembers(this.var.getChildren());
            }
            return this.members;
        }

        public NIFrame getFrame() {
            return this.var.getFrame();
        }
    }
}

